<?php
/**
 * Theme functions and definitions.
 *
 * For additional information on potential customization options,
 * read the developers' documentation:
 *
 * https://developers.elementor.com/docs/hello-elementor-theme/
 *
 * @package HelloElementorChild
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_CHILD_VERSION', '2.0.0' );

/**
 * Load child theme scripts & styles.
 *
 * @return void
 */
function hello_elementor_child_scripts_styles() {

	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		HELLO_ELEMENTOR_CHILD_VERSION
	);

}
add_action( 'wp_enqueue_scripts', 'hello_elementor_child_scripts_styles', 20 );


function enable_svg_uploads($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'enable_svg_uploads');




function my_custom_inline_script() {
    ?>
    <script type="text/javascript">
		document.addEventListener("DOMContentLoaded", function() {
			let scrollTopButton = document.querySelector('.scroll-top-button');

			window.addEventListener('scroll', function() {
				if (window.scrollY > 350) {
					scrollTopButton.style.opacity = '1';
				} else {
					scrollTopButton.style.opacity = '0';
				}
			});

			scrollTopButton.addEventListener('click', function() {
				window.scrollTo({
					top: 0,
					behavior: 'smooth'
				});
			});
		});
    </script>
    <?php
}
add_action('wp_footer', 'my_custom_inline_script');
